/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.kanos_config.api;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import virtuoel.kanos_config.api.ConfigHandler;

public class JsonConfigHandler
extends ConfigHandler<JsonObject> {
    public JsonConfigHandler(String namespace, Path path, Supplier<JsonObject> defaultConfig) {
        super(namespace, path, defaultConfig);
    }

    @Override
    public JsonObject readConfig(Stream<String> lines) {
        return Streams.parse((JsonReader)new JsonReader((Reader)new StringReader(lines.collect(Collectors.joining("\n"))))).getAsJsonObject();
    }

    @Override
    public Iterable<? extends CharSequence> writeConfig(JsonObject configData) throws IOException {
        StringWriter stringWriter = new StringWriter();
        JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);
        jsonWriter.setIndent("\t");
        Streams.write((JsonElement)configData, (JsonWriter)jsonWriter);
        stringWriter.write(10);
        return Arrays.asList(stringWriter.toString().split("\n"));
    }

    @Override
    public JsonObject mergeConfigs(JsonObject readConfig, JsonObject defaultConfig) {
        return JsonConfigHandler.mergeJsonObjects(new JsonObject(), defaultConfig, readConfig);
    }

    private static JsonObject mergeJsonObjects(JsonObject dest, JsonObject ... srcs) {
        for (JsonObject src : srcs) {
            for (Map.Entry srcEntry : src.entrySet()) {
                String key = (String)srcEntry.getKey();
                JsonElement value = (JsonElement)srcEntry.getValue();
                if (dest.has(key)) {
                    JsonElement destValue = dest.get(key);
                    if (destValue.isJsonArray() && value.isJsonArray()) {
                        JsonArray leftArr = destValue.getAsJsonArray();
                        for (JsonElement element : value.getAsJsonArray()) {
                            leftArr.add(element);
                        }
                        continue;
                    }
                    if (destValue.isJsonObject() && value.isJsonObject()) {
                        JsonConfigHandler.mergeJsonObjects(destValue.getAsJsonObject(), value.getAsJsonObject());
                        continue;
                    }
                    if (value.isJsonNull()) continue;
                    dest.add(key, value);
                    continue;
                }
                dest.add(key, value);
            }
        }
        return dest;
    }
}

